/**
 * Events dispatcher.
 */
class UIEventsHandler {
	/**
	 * Class constructor.
	 */
	constructor() {
		this.events = [];
	}

	/**
	 * Registers a new listener.
	 *
	 * @param 	function  event  A callable function.
	 *
	 * @return 	self      This object to support chaining.
	 */
	add(event) {
		// register listener
		this.events.push(event);

		return this;
	}

	/**
	 * Notifies all the subscribers.
	 *
	 * @return 	self  This object to support chaining.
	 */
	execute() {
		this.events.forEach((event, i) => {
			event();
		});

		return this;
	}
}

// export for external usage
module.exports = UIEventsHandler;
